RequireScript("common.js");
RequireScript("completed_functions.js");
const HEX_COUNT = 86;

function game() {
	var Traders = new _traders();
	Traders.start();
}

function _traders() {
	this.background; this.tradeButton = { what: "", since: 0, maxTime: 30 };
	this.helper = ""; this.discarders = [];
	this.font = LoadFont("frank.rfn"); this.mouse = LoadImage("mouse.png");
	this.window = [LoadWindowStyle("window.rws"),LoadWindowStyle("window2.rws"),LoadWindowStyle("window3.rws")];
	this.die = [LoadImage("dice1.png"),LoadImage("dice2.png"),LoadImage("dice3.png"),LoadImage("dice4.png"),LoadImage("dice5.png"),LoadImage("dice6.png")];
	this.dieRed = [LoadImage("dice1red.png"),LoadImage("dice2red.png"),LoadImage("dice3red.png"),LoadImage("dice4red.png"),LoadImage("dice5red.png"),LoadImage("dice6red.png")];
	this.portImage = [LoadImage("portBrick.png"), LoadImage("portOre.png"), LoadImage("portSheep.png"), LoadImage("portWheat.png"), LoadImage("portWood.png"), LoadImage("portThree.png")];
	this.developmentCards = [LoadImage("newCards/soldier.png"),LoadImage("newCards/roadBuilding.png"),LoadImage("newCards/monopoly.png"),LoadImage("newCards/yearOfPlenty.png"),LoadImage("newCards/chapel.png"),LoadImage("newCards/governersHouse.png"),LoadImage("newCards/library.png"),LoadImage("newCards/market.png"),LoadImage("newCards/university.png")];
		//soldier 0, rb 1, monopoly 2, yop 3, vp 4-8
	this.buttonsOn = [LoadImage("button4_on.png"), LoadImage("button5_on.png"), LoadImage("button6_on.png")];
	this.buttonsOff = [LoadImage("button4_off.png"), LoadImage("button5_off.png"), LoadImage("button6_off.png")];
	this.hexImage = [LoadImage("newTiles/nTileBrick.png"), LoadImage("newTiles/nTileOre.png"), LoadImage("newTiles/nTileSheep.png"), //0-2
		LoadImage("newTiles/nTileWheat.png"), LoadImage("newTiles/nTileWood.png"), LoadImage("newTiles/nTileDesert.png"),//3-5
		LoadImage("newTiles/nTileWater.png"), LoadImage("newTiles/nTileAll.png"), LoadImage("newTiles/nTileGreen.png"), //6-8
		LoadImage("newTiles/nTileRed.png"), LoadImage("newTiles/nTileIndicator.png"), LoadImage("newTiles/nTilePort.png"),//9-11
		LoadImage("newTiles/nTileGold.png")];
		//brick, ore, sheep, wheat, wood, desert, water, green, red
	this.resources = [LoadImage("resourceBrick.png"),LoadImage("resourceOre.png"),LoadImage("resourceSheep.png"),LoadImage("resourceWheat.png"),LoadImage("resourceWood.png")];
		//brick 0, ore 1, sheep 2, wheat 3, wood 4
	this.smallResource = [LoadImage("resourceBrickSmall.png"),LoadImage("resourceOreSmall.png"),LoadImage("resourceSheepSmall.png"),LoadImage("resourceWheatSmall.png"),LoadImage("resourceWoodSmall.png")];
	this.color = [CreateColor(0,0,0), CreateColor(255,255,255), CreateColor(255,0,0), CreateColor(0,128,255), CreateColor(190, 190, 190), CreateColor(128,128,128), CreateColor(0,255,0),CreateColor(255,255,255,100),CreateColor(255,255,0),
		CreateColor(255,128,0),CreateColor(128,0,255),CreateColor(170,0,0), CreateColor(241, 234, 141), CreateColor(0,0,0,200), CreateColor(60,60,60),
		CreateColor(0,0,175), CreateColor(0,0,175,120), CreateColor(190,190,190,100)];
		//black 0, white 1, red 2, blue 3, grey 4, darkgrey 5, green 6, whiteMask 7, yellow 8, orange 9, purple 10, 
		//darkred 11, tan 12, trans black 13, reallydarkgrey 14, chat blue border 15, chat background 16, trans gray 17
	this.pieceColors = [0,1,2,3,6,8,9,10,5];
	this.pieces = [];
		this.pieces.push([LoadImage("pieces/blackRoad.png"), LoadImage("pieces/blackBoat.png"), LoadImage("pieces/blackSettlement.png"), LoadImage("pieces/blackCity.png")]);
		this.pieces.push([LoadImage("pieces/whiteRoad.png"), LoadImage("pieces/whiteBoat.png"), LoadImage("pieces/whiteSettlement.png"), LoadImage("pieces/whiteCity.png")]);
		this.pieces.push([LoadImage("pieces/redRoad.png"), LoadImage("pieces/redBoat.png"), LoadImage("pieces/redSettlement.png"), LoadImage("pieces/redCity.png")]);
		this.pieces.push([LoadImage("pieces/blueRoad.png"), LoadImage("pieces/blueBoat.png"), LoadImage("pieces/blueSettlement.png"), LoadImage("pieces/blueCity.png")]);
		this.pieces.push([LoadImage("pieces/greenRoad.png"), LoadImage("pieces/greenBoat.png"), LoadImage("pieces/greenSettlement.png"), LoadImage("pieces/greenCity.png")]);
		this.pieces.push([LoadImage("pieces/yellowRoad.png"), LoadImage("pieces/yellowBoat.png"), LoadImage("pieces/yellowSettlement.png"), LoadImage("pieces/yellowCity.png")]);
		this.pieces.push([LoadImage("pieces/orangeRoad.png"), LoadImage("pieces/orangeBoat.png"), LoadImage("pieces/orangeSettlement.png"), LoadImage("pieces/orangeCity.png")]);
		this.pieces.push([LoadImage("pieces/purpleRoad.png"), LoadImage("pieces/purpleBoat.png"), LoadImage("pieces/purpleSettlement.png"), LoadImage("pieces/purpleCity.png")]);
		this.pieces.push([LoadImage("pieces/blankRoad.png")]);
	this.lastKey = 0;
	this.keyDelay = 5;
	this.phase = "login";
	this.candidate = -1;
	this.loginPage = 0;
	this.loginInfo = ["","","",""];
	this.players = [new _player(), new _player(), new _player()];
	this.mapSelected = 0; this.mapList;
	this.id = 0;
	this.port;
	this.started = false;
	this.robber = { where: [0,0], image: LoadImage("robber.png"), moved: 0 };
	this.toDiscard = [];
	this.background;
	this.image = [];
	this.image["tableCards"] = LoadImage("tablecards.png"); this.image["x"] = LoadImage("x.png"); this.image["resource"] = LoadImage("card.png");
		this.image["d_card"] = LoadImage("card2.png"); this.image["sSoldier"] = LoadImage("soldier_small.png"); this.image["vp"] = LoadImage("vp.png");
		this.image["trade"] = LoadImage("trade.png"); this.image["downArrow"] = LoadImage("downArrow.png"); this.image["longestRoad"] = LoadImage("longestRoad.png");
		this.image["bubbleDcard"] = LoadImage("cloudDcard.png"); this.image["largestArmy"] = LoadImage("soldiers_small.png"); 
	this.bubble = [LoadImage("leftBubble.png"), LoadImage("middleBubble.png"), LoadImage("rightBubble.png")];
	this.cloud = [LoadImage("cloudLeft.png"), LoadImage("cloudMiddle.png"), LoadImage("cloudRight.png")];
	this.turn = 0;
	this.portImage = [LoadImage("portBrick.png"), LoadImage("portOre.png"), LoadImage("portSheep.png"), LoadImage("portWheat.png"), LoadImage("portWood.png"),LoadImage("portThree.png")];
	//brick 0, ore 1, sheep 2, wheat 3, wood 4, 3:1
	this.ports = [];
	this.havePorts = [];
	this.longestRoad = -1;
	this.largestArmy = -1;
	this.roadsLimit = 15;
	this.boatLimit = 10;
	this.settlementLimit = 6;
	this.cityLimit = 4;
	this.options = { vpToWin: 9, noRobOn2: false, addBoats: false, addGoldMine: false };
	this.dice = [0,0];
	this.updates = [];
	this.allRolls = [0,0, 0,0,0,0,0, 0,0,0,0,0, 0];
	this.totalRolls = 0;
	this.lastRoll = 2;
	this.yop = [];
	this.rolled = false;
	this.starting = false;
	this.inChat = false;
	this.inDebug = false;
	this.chat = { id: ["","","","","", "","","","","", "","","","","", "","","","","", "","","","","", "","","","",""],
								text: ["","","","","", "","","","","", "","","","","", "","","","","", "","","","","", "","","","",""],
								smallId: ["","","","","", "","","","","", "","","","","", "","","","","", "","","","","", "","","","",""],
								smallText: ["","","","","", "","","","","", "","","","","", "","","","","", "","","","","", "","","","",""],
								input: "" };
	this.roadsBuilt = 0;
	this.initialize();
}	

_traders.prototype.start = function() {
	while(!IsKeyPressed(KEY_F4)) {
		this.draw();
		this.gatherInput();
		this.showUpdates();
		FlipScreen();
		this.lastKey++;
	}
}

_traders.prototype.getImage = function() {
	for (var i = 0; i < this.hex.length; i++) { 
		this.hexImage[this.hex[i].image].blit(this.hex[i].x, this.hex[i].y);
	}
	this.background = GrabImage(0,0,800,650);
}

_traders.prototype.showCloud = function(WIDTH, Y) {
	var x = 750;
	Y-= 48
	var rightPad = 0;
	this.cloud[2].blit(x, Y);
	for (var i=0; i<(WIDTH+rightPad); i++) { this.cloud[1].blit(x - i, Y); }
	this.cloud[0].blit(x-WIDTH-rightPad-12,Y);
}

_traders.prototype.showUpdates = function() {
	if (this.updates.length > 0) {
		this.font.setColorMask(this.color[0]);
		switch(this.updates[0].type) {
			case "resource": {
				for (var i = 0; i < this.players.length; i++) {
					if (this.updates[0].newResources[i].length > 0 ) {
						var width = (this.updates[0].newResources[i].length * 10) + 20;
						var textWidth = this.font.getStringWidth(this.players[i].name + " " + this.updates[0].type2);
						if (width < textWidth) { width = textWidth; }
						this.showCloud(width, 130+(i*120));
						this.font.drawText(758-width, 120 + (i * 120), this.players[i].name + " " + this.updates[0].type2);
						for (var j = 0; j < this.updates[0].newResources[i].length; j++) { this.smallResource[this.updates[0].newResources[i][j]].blit(758 -  width + (j*10), 135 + (i*120)); }
					}
				}
				break;
			}
			case "large": {
				this.image["bubbleDcard"].blit(760 - 124, 82 + (this.updates[0].who * 120));
				this.updates[0].what.blit(760 - 124 + 35, 107 + (this.updates[0].who * 120));
				break;
			}
			case "normal": {
				this.bubble[0].blit(this.updates[0].x, this.updates[0].y);
				var textWidth = this.font.getStringWidth(this.updates[0].text);
				for (var i = 0; i < textWidth; i++) { this.bubble[1].blit(this.updates[0].x + 10 + i, this.updates[0].y); }
				this.bubble[2].blit(this.updates[0].x + 10 + textWidth, this.updates[0].y);
				this.font.setColorMask(this.color[0]);
				this.font.drawText(this.updates[0].x + 10, this.updates[0].y + 4, this.updates[0].text);
				break;
			}
			case "robber": {
				var text = this.players[this.updates[0].whoRobbed].name + " stole a card from";
				var textWidth = this.font.getStringWidth(text);
				var secondLine = this.font.getStringWidth(this.players[this.updates[0].gotRobbed].name + "'s hand.");
				if (textWidth < secondLine) { textWidth = secondLine; }
				this.showCloud(textWidth, 120+(this.updates[0].whoRobbed*120));
				this.font.drawText(764 - textWidth, 120 + (this.updates[0].whoRobbed*120), text);
				this.font.drawText(764 - textWidth, 132 + (this.updates[0].whoRobbed*120), this.players[this.updates[0].gotRobbed].name + "'s hand.");
				break;
			}
			case "word": {
				var textWidth = this.font.getStringWidth(this.updates[0].text);
				var secondLine = this.font.getStringWidth(this.updates[0].text2);
				if (textWidth < secondLine) { textWidth = secondLine; }
				this.showCloud(textWidth, 120+(this.updates[0].who*120));
				this.font.drawText(764 - textWidth, 120 + (this.updates[0].who*120), this.updates[0].text);
				this.font.drawText(764 - textWidth, 132 + (this.updates[0].who*120), this.updates[0].text2);
				break;
			}
			case "single": {
				var width = (this.updates[0].gain.length * 10) + 40;
				var textWidth = this.font.getStringWidth(this.players[this.updates[0].who].name + " gained ");
				this.showCloud(width + textWidth, 130+(this.updates[0].who*120));
				this.font.drawText(758 - width - textWidth, 130 + (this.updates[0].who * 120), this.players[this.updates[0].who].name + " gained");
				for (var j = 0; j < this.updates[0].gain.length; j++) { this.smallResource[this.updates[0].gain[j]].blit(758 - width + (j*10), 130 + (this.updates[0].who*120)); }
				break;
			}
			case "double": {
				if (this.updates[0].who2 == "9") { var text = this.players[this.updates[0].who].name + " bank traded for"; }
				else { var text = this.players[this.updates[0].who].name + " trades for"; }
				var textWidth = this.font.getStringWidth(text);
				var width = (this.updates[0].gain.length * 10) + 40 + textWidth;
				this.showCloud(width, 130+(this.updates[0].who*120));
				this.font.drawText(758-width, 133 + (this.updates[0].who * 120), text);
				for (var j = 0; j < this.updates[0].gain.length; j++) { this.smallResource[this.updates[0].gain[j]].blit(758 - width + textWidth + (j*10) + 2, 130 + (this.updates[0].who*120)); }
				if (this.updates[0].who2 != "9") {
					var textWidth = this.font.getStringWidth(this.players[this.updates[0].who2].name + " trades for");
					var width = (this.updates[0].gain2.length * 10) + 40 + textWidth;
					this.showCloud(width, 130+(this.updates[0].who2*120));
					this.font.drawText(758-width, 133 + (this.updates[0].who2 * 120), this.players[this.updates[0].who2].name + " trades for");
					for (var j = 0; j < this.updates[0].gain2.length; j++) { this.smallResource[this.updates[0].gain2[j]].blit(758- width + textWidth + (j*10) + 2, 130 + (this.updates[0].who2*120)); }
				}
				break;
			}
			case "built": {
				var width = this.font.getStringWidth(this.players[this.updates[0].who].name + " spent") + (this.updates[0].what.length * 10) + 20;
				var secondLine = this.font.getStringWidth("for ") + (this.updates[0].built.length+10) + 20;
				if (width < secondLine) { var width2 = secondLine; }
				else { var width2 = width; }
				this.showCloud(width2, 130+(this.updates[0].who*120));
				this.font.drawText(758-width2, 130 + (this.updates[0].who * 120), this.players[this.updates[0].who].name + " spent");
				this.font.drawText(758-width2, 142 + (this.updates[0].who*120), "for ");
				var space = this.font.getStringWidth(this.players[this.updates[0].who].name + " spent")
				for (var i = 0; i < this.updates[0].what.length; i++) { this.smallResource[this.updates[0].what[i]].blit(758-width2+space+ (i*10), 130+(this.updates[0].who*120)); }
				var space = this.font.getStringWidth("for ");
				if (this.updates[0].built[0] == 5)  { this.image["d_card"].blit(758-width2+space, 142 + (this.updates[0].who*120)); }
				else {
					for (var j = 0; j < this.updates[0].built.length; j++) { this.smallResource[this.updates[0].built[j]].blit(758-width2+space+(j*10), 142 + (this.updates[0].who*120)); }
				}
				break;
			}
		}
		this.updates[0].timer++;
		if (this.updates[0].timer == 30) { this.updates.shift(); }
	}
}

_traders.prototype.draw = function() {
	var x = GetMouseX();
	var y = GetMouseY();
	//draw the usual first, then below, the manipulates 
	if (this.started || this.starting) {
		this.drawObject("background");
		this.drawObject("robbers");
		this.drawObject("pieces");
		this.drawObject("dice");
		this.drawObject("buttons");
		this.image["tableCards"].blit(875, 554);
	}
	this.drawObject("thisPlayer");
	
	switch(this.phase) {
		case "winner": {
			for (var i = 0; i < this.players.length; i++) {
				var posX = 200; var posY = 200 + (i * 75); 
				Rectangle(posX, posY, 400, 60, this.color[13]);
				var pColor = this.color[this.pieceColors[this.players[i].currentColor]];
				if (pColor == this.color[0]) { pColor = this.color[5]; }
				this.font.drawText(posX + 22, posY + 5, this.players[i].name); 
				if (this.players[i].points >= this.options.vpToWin) { this.font.setColorMask(this.color[8]); var lineColor = pColor; }
				else { this.font.setColorMask(this.color[1]); var lineColor = this.color[1]; }
				Line(posX , posY, posX + 400, posY, lineColor); 				 Line(posX, posY, posX, posY + 60, lineColor);
				Line(posX, posY + 60, posX + 400, posY + 60, lineColor); Line(posX+400, posY, posX+400, posY+60, lineColor);
				if (this.color[this.pieceColors[this.players[i].currentColor]] != this.color[0]) { Rectangle(posX + 5, posY + 5, 15, 15, pColor); }
				else { Rectangle(posX + 5, posY + 5, 15, 15, this.color[5]); Rectangle(posX + 6, posY + 6, 13, 13, pColor); }
				if (this.players[i].points < 10) { var a = 12; }
				else { var a = 0; }
				this.font.drawZoomedText(posX + 341 + a, posY + 2, 3, this.players[i].points);
				
				this.font.setColorMask(this.color[1]);
				this.font.drawText(posX + 150, posY + 5, "Career Points: ");
				this.font.drawText(posX + 300 - this.font.getStringWidth(this.players[i].careerPoints), posY + 5, this.players[i].careerPoints);
				this.font.drawText(posX + 150, posY + 20, "Wins: ");
				this.font.drawText(posX + 300 - this.font.getStringWidth(this.players[i].wins), posY + 20, this.players[i].wins);
				this.font.drawText(posX + 150, posY + 35, "Losses: ");
				this.font.drawText(posX + 300 - this.font.getStringWidth(this.players[i].losses), posY + 35, this.players[i].losses);
			}
			break;
		}
		case "receivedTrade": { //tradeButton : what, since, maxTime
			this.candidate = -1;
			if (this.tradeButton.what != "") { 
				this.tradeButton.since++; 
				if (this.tradeButton.since == this.tradeButton.maxTime) { 
					this.tradeButton.what = -1; this.tradeButton.since = 0;
				}
			}
			this.window[0].drawWindow(200, 150, 300, 180);
			this.window[0].drawWindow(505, 150, 150, 180);
			var pColor = this.color[this.pieceColors[this.receivedTrade]];
			if (pColor == this.color[0]) { pColor = this.color[1]; }
			this.font.setColorMask(pColor); 
			this.font.drawText(510, 155, this.players[this.receivedTrade].name);
			this.font.setColorMask(this.color[1]);
			for (var i = 0; i < this.smallResource.length; i++) {
				this.smallResource[i].blit(215 + (i * 25), 230);
				this.image["downArrow"].blit(215 + (i * 25), 280);
				this.smallResource[i].blit(366 + (i * 25), 230);
				this.image["downArrow"].blit(366 + (i * 25), 280);
				var j = this.findTradeResource(i, this.id, 0)
				if (j > 0) { this.font.drawText(221 + (i * 25), 262, j); }
				j = this.findTradeResource(i, this.id, 1)
				if (j > 0) { this.font.drawText(371 + (i * 25), 262, j); }
				if (isMouse(215 + (i * 25), 230, 25, 28)) { this.candidate = i; }
				if (isMouse(366 + (i * 25), 230, 25, 28)) { this.candidate = i + 5; }
				if (isMouse(215 + (i * 25), 280, 25, 10)) { this.candidate = i + 10; }
				if (isMouse(366 + (i * 25), 280, 25, 10)) { this.candidate = i + 15; }
			}
			this.font.drawText(245, 152, "Your Demand                Your Offer");
			var a = this.font.getStringWidth(this.players[this.receivedTrade].name + " ");
			this.font.drawText(510 + a, 155, "demands"); 
			this.font.drawText(530, 210, "and offers");
			for (var i in this.players[this.receivedTrade].tradeDemand) { this.smallResource[this.players[this.receivedTrade].tradeDemand[i]].blit(530 + (i * 10), 175); }
			for (var i in this.players[this.receivedTrade].tradeOffer) { this.smallResource[this.players[this.receivedTrade].tradeOffer[i]].blit(530 + (i * 10), 230); }
			Line(215, 167, 485, 167, this.color[1]);
			Line(350, 152, 350, 275, this.color[1]);
			if (this.tradeButton.what == "counter") { Rectangle(210, 300, 135, 16, this.color[4]); }
			else { Rectangle(210, 300, 135, 16, this.color[1]); }
			Rectangle(375, 300, 100, 16, this.color[1]);
			this.font.setColorMask(this.color[0]);
			this.font.drawText(215, 300, "Make Counter Offer");
			this.font.drawText(390, 300, "Leave Trade");
			if (this.tradeButton.what == "accept") { Rectangle(525, 265, 100, 16, this.color[4]); }
			else { Rectangle(525, 265, 100, 16, this.color[1]); }
			if (this.tradeButton.what == "donthave") { Rectangle(525, 285, 100, 16, this.color[4]); }
			else { Rectangle(525, 285, 100, 16, this.color[1]); }
			Rectangle(525, 305, 100, 16, this.color[1]);
			this.font.drawText(530, 265, "     Accept");
			this.font.drawText(530, 285, "   Don't Have");
			this.font.drawText(531, 305, "Not Interested");
			if (this.players[this.id].tradeDemand.length > 0) {
				for (var i = 0; i < this.players[this.id].tradeDemand.length; i++) { this.smallResource[this.players[this.id].tradeDemand[i]].blit(265 + (i * 10), 190); }
			}
			if (this.players[this.id].tradeOffer.length > 0) {
				for (var i = 0; i < this.players[this.id].tradeOffer.length; i++) { this.smallResource[this.players[this.id].tradeOffer[i]].blit(400 + (i * 10), 190); }
			}
			break;
		}
		case "discard": {
			this.candidate = -1;
			var position = this.players[this.id].resources.length * 10;
			var selected = 0;
			for (var i = 0; i < this.players[this.id].resources.length; i++) {
				var offset = 0;
				if (this.toDiscard[i] != "no") { offset = 10; selected++; }
				if (isMouse(499 - position + (i * 20), 650 - offset, 20, 92)) { this.candidate = i; }
				this.resources[this.players[this.id].resources[i]].blit(499 - position + (i * 20), 650 - offset);
			}
			if (selected == this.players[this.id].discard) {
				Rectangle(449, 610, 125, 16, this.color[1]);
				this.font.setColorMask(this.color[0]);
				this.font.drawText(458, 610, "Discard Selected");
				if (isMouse(449, 610, 125, 16)) { this.candidate = "discard"; }
			}
			else {
				this.font.setColorMask(this.color[1]);
				var a = this.font.getStringWidth("Pick " + this.players[this.id].discard + " resources to discard") / 2;
				this.font.drawText(509 - a, 610, "Pick " + this.players[this.id].discard + " resources to discard");
			}
			break;
		}
		case "yop": {
			this.candidate = -1;
			this.window[0].drawWindow(270, 220, 200, 160);
			if (this.yop.length == 2) {
				Rectangle(330, 350, 80, 16, this.color[1]);
				this.font.setColorMask(this.color[0]);
				this.font.drawText(347, 350, "Confirm");
				if (isMouse(330, 350, 80,16)) { this.candidate = 10; }
			}
			this.font.setColorMask(this.color[1]);
			this.font.drawText(280, 234, "Pick 2 resources");
			var took = [0,0,0,0,0];
			for (var i in this.yop) { took[this.yop[i]]++; }
			for (var i in took) { if (took[i] != 0) { this.font.drawText(306 + (i * 30), 302, took[i]); } }
			Line(280, 250, 464, 250, this.color[1]);
			for (var i in this.smallResource) { 
				this.smallResource[i].blit(300 + (i * 30), 270); 
				this.image["downArrow"].blit(300 + (i * 30), 320);
				if (isMouse(300+(i*30), 270, 19, 28)) { this.candidate = i; }
				if (isMouse(300+(i*30), 320, 19, 10)) { this.candidate = i + 5; }
			}
			break;
		}
		case "monopoly": {
			this.candidate = -1;
			this.window[0].drawWindow(270, 220, 200, 110);
			this.font.setColorMask(this.color[1]);
			this.font.drawText(280, 234, "Pick a resource to monopolize");
			Line(280, 250, 464, 250, this.color[1]);
			for (var i = 0; i < this.smallResource.length; i++) { 
				this.smallResource[i].blit(300 + (i * 30), 270); 
				if (isMouse(300+(i*30),270, 19,28)) { this.candidate = i; }
			}
			break;
		}
		case "rob": {
			this.candidate = -1;
			for (var i = 0; i < this.players.length; i++) {
				if (isMouse(780, 100 + (i * 120), 400, 120) && this.id != i) { this.candidate = i; }
			}
			break;
		}
		case "placeRobber": {
			this.candidate = -1;
			for (var i = 0; i < this.hex.length; i++) {
				if (isMouse(this.hex[i].x + 2, this.hex[i].y + 5, 65, 70)) {
					if(this.robber.where[0] != i && this.robber.where[1] != i && this.hex[i].image < 5 && this.ableToRob(i)) {
						this.hexImage[8].blit(this.hex[i].x, this.hex[i].y);
						this.candidate = i;
					}
					else { this.hexImage[9].blit(this.hex[i].x, this.hex[i].y); }
				}
			}
			break;
		}
		case "pickRobber": {
			this.robber.moved = -1;
			for (var i = 0; i < this.robber.where.length; i++) {
				if (isMouse(this.hex[this.robber.where[i]].x + 2, this.hex[this.robber.where[i]].y + 5, 65, 70)) {
					this.robber.moved = i;
					this.hexImage[8].blit(this.hex[this.robber.where[i]].x, this.hex[this.robber.where[i]].y);
				}
			}
			break;
		}
		case "trade": {
			if (this.tradeButton.what != "") { 
				this.tradeButton.since++; 
				if (this.tradeButton.since == this.tradeButton.maxTime) { 
					this.tradeButton.what = -1; this.tradeButton.since = 0;
				}
			}
			this.tradeBank(this.id);
			this.image["trade"].blit(100,100);
			for (var a in this.players[this.id].tradeOffer)  { this.smallResource[this.players[this.id].tradeOffer[a]].blit(300 + (a * 10), 205);  }
			for (var a in this.players[this.id].tradeDemand) { this.smallResource[this.players[this.id].tradeDemand[a]].blit(165 + (a * 10), 205); }
			this.font.setColorMask(this.color[1]);
			for (var i in this.smallResource) {
				var j = this.findTradeResource(i, this.id, 0);
				if (j > 0) { this.font.drawText(131 + (i * 25), 280, j); }
				var j = this.findTradeResource(i, this.id, 1);
				if (j > 0) { this.font.drawText(283 + (i * 25), 280, j); }
			}
			if (this.bank.reply == "no") { this.font.drawText(420, 160, "Bank does not accept."); }
			else {
				this.font.drawText(425, 130, "Demands     Offers");
				for (var a in this.bank.demand) { this.smallResource[this.bank.demand[a]].blit(430 + (a * 7), 150); }
				for (var a in this.bank.offer) { this.smallResource[this.bank.offer[a]].blit(510 + (a * 7), 150); }
				Rectangle(435, 182, 100, 16, this.color[1]);
				this.font.setColorMask(this.color[0]);
				this.font.drawText(444, 182, "Accept Offer");
			}
			var times = 0;
			for (var i=0; i < this.players.length; i++) {
				if (this.id != i) {
					var offset = (times * 98);
					this.font.setColorMask(this.color[1]);
					this.font.drawText(420, 208 + offset, "(" + this.players[i].points + ")");
					if (this.players[i].tradeTalk == "" && this.players[i].tradeDemand.length == 0 && this.players[i].tradeOffer.length == 0) {
						this.font.drawText(420, 258 + offset, "Waiting on reply...");
					}
					else if (this.players[i].tradeTalk != "") {
						this.font.drawText(420, 258 + offset, this.players[i].tradeTalk);
					}
					else {
						this.font.drawText(425, 228 + offset, "Demands     Offers");
						for (var j in this.players[i].tradeDemand) { this.smallResource[this.players[i].tradeDemand[j]].blit(430 + (j * 7), 248 + offset); }
						for (var j in this.players[i].tradeOffer)  { this.smallResource[this.players[i].tradeOffer[j]].blit(510 + (j * 7), 248 + offset); }
						Rectangle(435, 280 + offset, 100, 16, this.color[1]);
						this.font.setColorMask(this.color[0]);
						this.font.drawText(444, 280 + offset, "Accept Offer");
					}
					var b = this.font.getStringWidth("(" + this.players[i].points + ") ");
					var pColor = this.color[this.pieceColors[this.players[i].currentColor]];
					if (pColor == this.color[0]) { pColor = this.color[1]; }
					this.font.setColorMask(pColor);
					this.font.drawText(420 + b, 208 + offset, this.players[i].name);
					times++;
				}
			}
			if (this.tradeButton.what == "propose") { Rectangle(140, 320, 100, 16, this.color[17]); }
			break;
		}	
		case "main": { 
			this.candidate = [];
			if (x < 760 && y < 575) { //on the board.
				if (this.findResource(0,1,this.id) && this.findResource(4,1,this.id)) { //road.
					var roads = this.findNearRoad(this.id);
					if (roads.length > 0) {
						for (var j = 0; j < roads.length; j++) {
							var x1 = this.corners[this.roads[roads[j]][0]].x;
							var y1 = this.corners[this.roads[roads[j]][0]].y;
							var x2 = this.corners[this.roads[roads[j]][1]].x;
							var y2 = this.corners[this.roads[roads[j]][1]].y;
							//road, boat, settlement, city.
							if (y1 > y2 && x1 != x2) { //diagonal up 
								if (isMouse(x1, y2, 20, 20)) { 
									this.pieces[this.players[this.id].currentColor][0].rotateBlit(x1 + 15, y1 - 20, DegreesToRadians(60));
									this.candidate = ["road", roads[j]];
								}
								else { this.pieces[8][0].rotateBlit(x1 + 15,y1 - 20,DegreesToRadians(60)); }
							}
							else if (y1 < y2 && x1 != x2) { //diagonal down
								if (isMouse(x1, y1, 20, 20)) {
									this.pieces[this.players[this.id].currentColor][0].rotateBlit(x1 + 15, y1 + 1, DegreesToRadians(300));
									this.candidate = ["road", roads[j]];
								}
								else { this.pieces[8][0].rotateBlit(x1 + 15,y1 + 1,DegreesToRadians(300)); }
							} 
							else {
								if (isMouse(x1 - 10, y1, 20, 20)) {
									this.pieces[this.players[this.id].currentColor][0].blit(x1 - 3, y1 + 9);
									this.candidate = ["road", roads[j]];
								}
								else { this.pieces[8][0].blit(x1 - 3, y1 + 9); }
							}
						}
					}
				}
				if (this.findResource(0,1,this.id) && this.findResource(2,1,this.id) && this.findResource(3,1,this.id) && this.findResource(4,1,this.id)) {//settlement
					var settle = this.showNewSettlement(this.id);
					if (settle.length > 0) {
						for (var i = 0; i < settle.length; i++) {
							if (isMouse(this.corners[settle[i]].x-11, this.corners[settle[i]].y-6, 17, 17)) {
								this.pieces[this.players[this.id].currentColor][2].blit(this.corners[settle[i]].x - 9, this.corners[settle[i]].y - 4);
								this.candidate = ["settlement", settle[i]];
							}
						}
					}
				}
				if (this.findResource(1,3,this.id) && this.findResource(3,2,this.id)) { //city
					if (this.players[this.id].settlements.length > 0) {
						for (var i = 0; i < this.players[this.id].settlements.length; i++) {
							var choice = this.players[this.id].settlements[i];
							if (isMouse(this.corners[choice].x - 11, this.corners[choice].y - 6, 17, 17)) {
								this.pieces[this.players[this.id].currentColor][3].blit(this.corners[choice].x - 9, this.corners[choice].y - 4);
								this.candidate = ["city", i];
							}
						}
					}
				}
			}
			else { //outside of the board
				if (isMouse(20, 580, 50, 50)) { //development card
					this.candidate = ["d_card", -1];
					this.font.drawText(30, 620, "Buy a development cards");
					this.buttonsOn[0].blit(20, 580);
				}
				else if (isMouse(70, 580, 50, 50)) { //trade
					this.candidate = ["trade", -1];
					this.font.drawText(80, 620, "Enter the trade window.");
					this.buttonsOn[1].blit(70, 580);
				}
				else if (isMouse(120, 580, 50, 50)) { //end turn
					this.candidate = ["end", -1];
					this.font.drawText(130, 620, "End your turn");
					this.buttonsOn[2].blit(120,580);
				}
				for (var i = 0; i < this.players[this.id].d_cards.length; i++) {
					if (isMouse(900 + (i * 20), 680, 20, 105)) { this.candidate = ["playd_card", i]; }
				}
			}
			break;
		}
		case "settlement": { //for setup.
			this.candidate = [];
			for (var i = 0; i < this.corners.length; i++) {
				if (isMouse(this.corners[i].x-10, this.corners[i].y-10, 20, 20)) {
					if (this.corners[i].occupied == -1) { 
						this.pieces[this.players[this.id].currentColor][2].blit(this.corners[i].x - 9, this.corners[i].y - 4);
						this.candidate = ["settlement", i];
					}
				}
			}
			break;
		}
		case "road": //for setup.
		case "roadBuilder": {
			this.candidate = [];
			var roads = this.findNearRoad(this.id);
			for (var j = 0; j < roads.length; j++) {
				var x1 = this.corners[this.roads[roads[j]][0]].x;
				var y1 = this.corners[this.roads[roads[j]][0]].y;
				var x2 = this.corners[this.roads[roads[j]][1]].x;
				var y2 = this.corners[this.roads[roads[j]][1]].y;
				//road, boat, settlement, city.
				if (y1 > y2 && x1 != x2) { //diagonal up 
					if (isMouse(x1, y2, 20, 20)) { 
						this.pieces[this.players[this.id].currentColor][0].rotateBlit(x1 + 15, y1 - 20, DegreesToRadians(60));
						this.candidate = ["road", roads[j]];
					}
					else { this.pieces[8][0].rotateBlit(x1 + 15,y1 - 20,DegreesToRadians(60)); }
				}
				else if (y1 < y2 && x1 != x2) { //diagonal down
					if (isMouse(x1, y1, 20, 20)) {
						this.pieces[this.players[this.id].currentColor][0].rotateBlit(x1 + 15, y1 + 1, DegreesToRadians(300));
						this.candidate = ["road", roads[j]];
					}
					else { this.pieces[8][0].rotateBlit(x1 + 15,y1 + 1,DegreesToRadians(300)); }
				} 
				else {
					if (isMouse(x1 - 10, y1, 20, 20)) {
						this.pieces[this.players[this.id].currentColor][0].blit(x1 - 3, y1 + 9);
						this.candidate = ["road", roads[j]];
					}
					else { this.pieces[8][0].blit(x1 - 3, y1 + 9); }
				}
			}
			break;
		}
		case "login": {
			this.font.drawZoomedText(100, 10, 20, "Traders");
			this.font.setColorMask(this.color[2]);
			this.font.drawText(515, 290, this.loginInfo[3]);
			this.font.setColorMask(this.color[8]); this.font.drawText(460, 512, "Press 'ENTER' when you've filled out all fields");
			this.font.drawText(494, 500, "Press 'TAB' to cycle through fields");
			this.font.setColorMask(this.color[1]);
			for (var i = 0; i < this.loginInfo.length - 1; i++) {
				var a = "";
				if (this.loginPage == i) { 
					this.window[2].drawWindow(500, 330 + (i*60), 200, 20); 
					a = "_";
				}
				else { this.window[0].drawWindow(500, 330 + (i*60), 200, 20); }
				if (i == 1) {
					var b = "";
					for (var j = 0; j < this.loginInfo[1].length; j++) { b+="*"; }
					this.font.drawText(502, 394, b + a);
				}
				else { this.font.drawText(502, 334 + (i * 60), this.loginInfo[i] + a); }
			}
			this.font.drawText(500, 310, "Account Name");
			this.font.drawText(500, 370, "Password");
			this.font.drawText(500, 430, "Server Address");
			break;
		}
		case "connecting": {
			if (this.port.isConnected()) {
				this.send("login*" + this.loginInfo[0] + "*" + this.loginInfo[1] + "\n");
				this.phase = "wait";
			}
			else {
				this.font.setColorMask(this.color[1]);
				this.font.drawText(400, 350, "Connecting to...");
				this.font.setColorMask(this.color[8]);
				var a = this.font.getStringWidth("Connecting to... ");
				this.font.drawText(402 + a, 350, this.loginInfo[2]);
			}
			break;
		}
		case "lobby": { 
			var vSpace = 120;
			var offset = 90;
			for (var i = 0; i < this.players.length; i++) { //show players
				var pColor = this.color[this.pieceColors[this.players[i].currentColor]];
				if (this.players[i].name != "") {
					if (pColor != undefined) { 
						if (pColor != this.color[0]) { Rectangle(780, 100 + (i * vSpace) + offset, 20, 20, pColor); }
						else  { Rectangle(780, 100 + (i * vSpace) + offset, 20, 20, this.color[5]); Rectangle(781, 101 + (i * vSpace) + offset, 18, 18, this.color[0]); }
					}
					if (pColor != this.color[0] && this.players[i].currentColor != undefined) { this.font.setColorMask(pColor); }
					else { this.font.setColorMask(this.color[1]); }
					this.font.drawText(805, 100 + (i * vSpace) + offset, this.players[i].name);
					this.font.setColorMask(this.color[1]);
					this.font.drawText(805, 122 + (i * vSpace) + offset, "Games:");
					var games = parseFloat(this.players[i].wins)+parseFloat(this.players[i].losses);
					this.font.drawText(975 - this.font.getStringWidth(games), 122 + (i * vSpace) + offset, games);
					this.font.drawText(805, 134 + (i * vSpace) + offset, "Wins: ");
					this.font.drawText(975 - this.font.getStringWidth(this.players[i].wins), 134 + (i * vSpace) + offset, this.players[i].wins);
					this.font.drawText(805, 146 + (i * vSpace) + offset, "Losses: ");
					this.font.drawText(975 - this.font.getStringWidth(this.players[i].losses), 146 + (i * vSpace) + offset, this.players[i].losses);
					this.font.drawText(805, 158 + (i * vSpace) + offset, "Career Points:");
					this.font.drawText(975 - this.font.getStringWidth(this.players[i].careerPoints), 158 + (i * vSpace) + offset, this.players[i].careerPoints);
				}
				else {
					Rectangle(780, 100 + (i * vSpace) + offset, 20, 20, this.color[5]);
					Rectangle(781, 101 + (i * vSpace) + offset, 18, 18, this.color[0]);
					this.font.setColorMask(this.color[1]);
					this.font.drawText(825, 100 + (i * vSpace) + offset, "Waiting for player...");
				}
			}
			//map list, game options...
			if (this.id == 0) {
				this.font.drawText(1000, 100, "- Select a Map -");
				Rectangle(1000, 117, 170, 380, this.color[5]);
				Rectangle(1001, 118, 168, 378, this.color[0]);
				Rectangle(990, 124 + (this.mapSelected*18), 190, 20, this.color[2]); //which map choice is selected
				for (var i = 0; i < this.mapList.length; i++) { this.font.drawText(1015, 125 + (i * 18), this.mapList[i]); }
				if (isMouse(1020,507,100,20)) { this.window[2].drawWindow(1020, 507, 100, 20); }
				else { this.window[0].drawWindow(1020, 507, 100, 20); }
				this.font.drawText(1025, 509, " START GAME"); 
			}
			else {
				this.font.drawText(1000, 100, "- Current Map -");
				Rectangle(1000, 117, 170, 34, this.color[5]);
				Rectangle(1001, 118, 168, 32, this.color[0]);
				Rectangle(990, 124, 190, 20, this.color[2]); //which map choice is selected
				this.font.drawText(1015, 125, this.mapList[this.mapSelected]);
			}
			Rectangle(801,11 + offset,20,20,this.color[5]); //for the black piece
			for (var j = 0; j < this.players.length; j++) {
				if (this.players[j].name != "" && this.players[j].currentColor != undefined) {
					if (this.players[j].currentColor != 0) { var useColor = this.color[this.pieceColors[this.players[j].currentColor]]; }
					else { var useColor = this.color[5]; }
					if (this.players[j].currentColor < 4) { var vertSpace = 0 + (j*2); var offset2 = 0; }
					else { var vertSpace = 30 + (j*2); var offset2 = 4; }
					var hSpace = j * 2;
					Line(770 - hSpace, 32 + vertSpace + offset, 810 + ((this.players[j].currentColor - offset2) * 30), 32 + vertSpace + offset, useColor);
					Line(810 + ((this.players[j].currentColor - offset2) * 30), 32 + vertSpace + offset, 810 + ((this.players[j].currentColor - offset2) * 30), 29 + vertSpace + offset, useColor);
					Line(770 - hSpace, 32 + vertSpace + offset, 770 - hSpace, 110 + (j * 120) + offset, useColor);
					Line(770 - hSpace, 110 + (j * 120) + offset,780,110+(j*120) + offset, useColor);
				}
			}
			for (var i = 0; i < 4; i++) {
				Rectangle(800+(i*30), 10 + offset, 20, 20, this.color[this.pieceColors[i]]);
				Rectangle(800+(i*30), 40 + offset, 20, 20, this.color[this.pieceColors[i+4]]);
			}
			for (var i = 0; i < this.players.length; i++) {
				if (this.players[i].currentColor != undefined && this.players[i].name != "") {
					if (this.players[i].currentColor < 4) { var space = 0; var hSpace = 0; }
					else { var space = 30; var hSpace = 4; }
					var a = 800+(30 *(this.players[i].currentColor-hSpace));
					Triangle(a, 30 + space + offset, a + 20, space + 10 + offset, a + 20, 30 + space + offset, CreateColor(100,100,100,150));
				}
			}
			
			this.font.drawText(790, 66 + offset, "Choose a piece color");
			for (var i = 0; i < 4; i++) {
				if (isMouse(800+(i*30),10 + offset,20,20)) {
					if (!this.doPlayerColorsMatch(i)) {
						Rectangle(798+(i*30),8 + offset,24,24,this.color[5]);
						Rectangle(800+(i*30),10 + offset,20,20,this.color[this.pieceColors[i]]);
					}
				}
				if (isMouse(800+(i*30),40 + offset,20,20)) {
					if (!this.doPlayerColorsMatch(i+4)) {
						Rectangle(798+(i*30),38 + offset,24,24,this.color[5]);
						Rectangle(800+(i*30),40 + offset,20,20,this.color[this.pieceColors[i+4]]);
					}
				}
			}
			this.font.drawText(800, 530, "No robber on 2pts");
			this.font.drawText(800, 598, "How many VP's to win");
			this.font.setColorMask(this.color[14]);
			this.font.drawText(800, 545, "Add Boats");
			this.font.drawText(800, 560, "Add Gold Mines");
			Rectangle(780, 532, 10, 10, this.color[1]);
			if (this.options.noRobOn2) { Rectangle(782, 534, 6, 6, this.color[0]); }
			Rectangle(780, 547, 10, 10, this.color[14]);
			//if (this.options.addBoats) { Rectangle(782, 549, 6, 6, this.color[0]); }
			Rectangle(780, 562, 10, 10, this.color[14]);
			//if (this.options.addGoldMine) { Rectangle(782, 564, 6 , 6, this.color[0]); }
			var text = "";
			for (var j = 9; j < 16; j++) {
				if (j == this.options.vpToWin) { var color = this.color[1]; }
				else  { 
					var a = this.font.getStringWidth(text);
					if (this.id == 0 && isMouse(795 + a, 608, this.font.getStringWidth(text + "  " + j) - this.font.getStringWidth(text), 15)) { 
						var color = this.color[6]; 
						this.candidate = j;
					}
					else { var color = this.color[14]; }
				}
				this.font.setColorMask(color);
				this.font.drawText(795 + this.font.getStringWidth(text), 610, j);
				text += "  " + j;
			}
			this.font.setColorMask(this.color[1]);
			
			this.drawObject("hex");
			if (this.ports.length != 0) { this.drawObject("port"); } 
			break;
		}
	}
	if (this.started || this.starting) { this.drawObject("players"); }
	this.updateChat();
	this.status();
	this.mouse.blit(GetMouseX(), GetMouseY());
}

_traders.prototype.gatherInput = function() {
	var x = GetMouseX();
	var y = GetMouseY();
	
	switch(this.phase) {
		case "receivedTrade": {
			if(IsMouseButtonPressed(MOUSE_LEFT) && this.checkKeyDelay()) {
				if (this.candidate != -1) {
					if (this.candidate < 5) { this.players[this.id].tradeDemand.push(this.candidate); }
					if (this.candidate > 4 && this.candidate < 10) { this.players[this.id].tradeOffer.push(this.candidate-5); }
					if (this.candidate > 9 && this.candidate < 15) {
						var location = -1;
						for (var i = 0; i < this.players[this.id].tradeDemand.length; i++) {
							if ((this.candidate - 10) == this.players[this.id].tradeDemand[i]) { location = i; }
						}
						if (location != -1) { this.players[this.id].tradeDemand.splice(location, 1); }
					}
					if (this.candidate > 14 && this.candidate < 20) {
						var location = -1;
						for (var i = 0; i < this.players[this.id].tradeOffer.length; i++) {
							if ((this.candidate - 15) == this.players[this.id].tradeOffer[i]) { location = i; }
						}
						if (location != -1) { this.players[this.id].tradeOffer.splice(location, 1); }
					}
				}
				else {
					if (isMouse(210, 300, 100, 16) && this.players[this.id].tradeOffer.length > 0 && this.players[this.id].tradeDemand.length > 0) {
						this.send("propose*" + this.players[this.id].tradeDemand + "*" + this.players[this.id].tradeOffer + "\n"); 
						this.tradeButton.what = "counter";
					}
					else if (isMouse(375, 300, 100, 16)) {
						this.send("leaveTrade\n");
						this.phase = "wait";
					}
					else if (isMouse(525, 265, 100, 16)) {
						var need = [0,0,0,0,0];
						for (var i = 0; i < this.players[this.turn].tradeDemand.length; i++) { need[this.players[this.turn].tradeDemand[i]]++; }
						if (this.findAllResource(need, this.id)) {
							for (var i = 0; i < this.players[this.turn].tradeDemand.length; i++) { this.players[this.id].tradeOffer.push(this.players[this.turn].tradeDemand[i]); }
							for (var i = 0; i < this.players[this.turn].tradeOffer.length;  i++) { this.players[this.id].tradeDemand.push(this.players[this.turn].tradeOffer[i]); }
							this.send("propose*" + this.players[this.id].tradeDemand + "*" + this.players[this.id].tradeOffer + "\n");
							this.tradeButton.what = "accept";
						}
					}
					else if (isMouse(525, 285, 100, 16)) { this.send("tradeResponse*dont have\n"); this.tradeButton.what = "donthave"; }
					else if (isMouse(525, 305, 100, 16)) { this.send("leaveTrade\n"); this.phase = "wait"; }
				}
				this.lastKey = 0;
			}
			break;
		}
		case "discard": {
			if (IsMouseButtonPressed(MOUSE_LEFT) && this.checkKeyDelay()) {
				var selected = 0;
				for (var i = 0; i < this.toDiscard.length; i++) {
					if (this.toDiscard[i] == "yes") { selected++; }
				}
				if (this.candidate != -1) {
					if (this.toDiscard[this.candidate] == "yes") { this.toDiscard[this.candidate] = "no"; }
					else if (this.toDiscard[this.candidate] == "no" && selected < this.players[this.id].discard) { this.toDiscard[this.candidate] = "yes"; }
				}
				if (this.candidate == "discard") {
					var discards = [];
					for (var i = 0; i < this.players[this.id].resources.length; i++) {
						if (this.toDiscard[i] == "yes") { discards.push(this.players[this.id].resources[i]); }
					}
					discards.sort(compareNumbers);
					this.send("discard*" + discards + "\n");
					this.phase = "wait";
				}
				this.lastKey = 0;
			}
			break;
		}
		case "yop": {
			if (this.candidate != -1 && IsMouseButtonPressed(MOUSE_LEFT) && this.checkKeyDelay()) {
				if (this.candidate < 5 && this.yop.length < 2) { this.yop.push(this.candidate); }
				else if (this.candidate > 4 && this.candidate < 10) {
					var down = -1;
					for (var i = 0; i < this.yop.length; i++) {
						if (this.yop[i] == (this.candidate - 5)) { down = i; }
					}
					if (down != -1) { this.yop.splice(down,1); }
				}
				else if (this.candidate == 10) {
					this.send("yop*" + this.yop[0] + "*" + this.yop[1] + "\n");
					this.phase = "wait";
				}
				this.lastKey = 0;
			}
			break;
		}
		case "monopoly": {
			if (this.candidate != -1 && IsMouseButtonPressed(MOUSE_LEFT) && this.checkKeyDelay()) {
				this.send("monopoly*" + this.candidate + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "roadBuilder": {
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT) && this.candidate.length != 0) {
				this.roadsBuilt++;
				this.send("dRoad*" + this.candidate[1] + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "settlement": {
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT) && this.candidate.length != 0) {
				this.send("settlement*" + this.candidate[1] + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "road": {
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT) && this.candidate.length != 0) {
				this.send("road*" + this.candidate[1] + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "rob": {
			if (this.candidate != -1 && this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				this.send("robbed*" + this.candidate + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "placeRobber": {
			if (this.candidate != -1 && IsMouseButtonPressed(MOUSE_LEFT) && this.checkKeyDelay()) {
				this.mouse = LoadImage("mouse.png");
				this.send("robber*" + this.robber.moved + "*" + this.candidate + "\n");
				this.phase = "wait";
				this.lastKey = 0;
			}
			break;
		}
		case "pickRobber": {
			if (this.robber.moved != -1 && this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				this.mouse = this.robber.image;
				this.send("choseRobber\n");
				this.phase = "placeRobber";
				this.lastKey = 0;
			}
			break;
		}
		case "roll": {
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				if(isMouse(690, 580, 60, 40)) {
					this.send("roll\n");
					this.phase = "wait";
				}
				if (!this.players[this.id].playedRobber) {
					for (var i = 0; i < this.players[this.id].d_cards.length; i++) {
						if(isMouse(900+(i*20),680, 20, 105) && this.players[this.id].d_cards[i] == 0) {
							this.send("soldier\n");
							this.players[this.id].playedRobber = true;
							this.phase = "wait";
						}
					}
				}
				this.lastKey = 0;
			}
			break;
		}
		case "trade": {
			this.tradeBank(this.id);
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				for (var i = 0; i < 5; i++) {
					if (isMouse(125+(i*25), 250, 19, 28)) { this.players[this.id].tradeDemand.push(i); }
					if (isMouse(276+(i*25), 250, 19, 28) && this.findTradeResource(i,this.id)) { this.players[this.id].tradeOffer.push(i); }
					if (isMouse(125+(i*25), 300, 19, 10)) {
						var location = -1;
						for (var j = 0; j < this.players[this.id].tradeDemand.length; j++) {
							if (i == this.players[this.id].tradeDemand[j] && location == -1) { location = j; }
						}
						if (location != -1) { this.players[this.id].tradeDemand.splice(location, 1); }
					}
					if (isMouse(276+(i*25), 300, 19, 10)) {
						var location = -1;
						for (var j = 0; l < this.players[this.id].tradeOffer.length; j++) {
							if (i == this.players[this.id].tradeOffer[j] && location == -1) { location = j; }
						}
						if (location != -1) { this.players[this.id].tradeOffer.splice(location, 1); }
					}
				}
				if (isMouse(140, 320, 100, 16) && this.players[this.id].tradeOffer.length > 0 && this.players[this.id].tradeDemand.length > 0) {
					this.send("propose*" + this.players[this.id].tradeDemand + "*" + this.players[this.id].tradeOffer + "\n");
					for (var j = 0; j < this.players.length; j++) { 
						if (j != this.turn) { 
							this.players[j].tradeDemand = [];
							this.players[j].tradeOffer = [];
							this.players[j].tradeTalk = "";
						}
					}
					this.tradeButton.what = "propose";
				}
				if (isMouse(270, 320, 100, 16)) {//leave trade
					this.send("leftTrade\n");
					this.phase = "main";
				}
				if (isMouse(435, 182, 100, 16) && this.bank.reply == "yes") {
					var need = [0,0,0,0,0];
					for (var i = 0; i < this.bank.demand.length; i++) { need[this.bank.demand[i]]++; }
					if (this.findAllResource(need, this.id)) {
						this.send("trade*9*" + this.bank.demand + "*" + this.bank.offer + "\n");
						this.phase = "wait";
					}
				}
				var times = 0;
				for (var i=0; i < this.players.length; i++) {
					var need = [0,0,0,0,0];
					if (this.id != i) {
						if (isMouse(435, 280 + (times*98), 100, 16) && this.players[i].tradeDemand.length > 0 && this.players[i].tradeOffer.length > 0) {
							for (var j = 0; j < this.players[i].tradeDemand.length; j++) { need[this.players[i].tradeDemand[j]]++; }
							if (this.findAllResource(need,this.id)) {
								this.send("trade*" + i + "*" + this.players[i].tradeDemand + "*" + this.players[i].tradeOffer + "\n");
								this.phase = "wait";
							}
						}
						times++;
					}
				}
				this.lastKey = 0;
			}
			break;
		}
		case "main": {
			if (this.candidate.length != 0 && this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				switch(this.candidate[0]) {
					case "road": {
						this.send("road*" + this.candidate[1] + "\n");
						this.phase = "wait";
						this.lastKey = 0;
						break;
					}
					case "boat": {
						this.send("boat*" + this.candidate[1] + "\n");
						this.phase = "wait";
						this.lastKey = 0;
						break;
					}
					case "settlement": {
						this.send("settlement*" + this.candidate[1] + "\n");
						this.phase = "wait";
						this.lastKey = 0;
						break;
					}
					case "city": {
						this.send("city*" + this.candidate[1] + "\n");
						this.phase = "wait";
						this.lastKey = 0;
						break;
					}
					case "d_card": {
						if (this.findResource(1,1,this.id) && this.findResource(2,1,this.id) && this.findResource(3,1,this.id)) {
							this.send("buydCard\n");
							this.phase = "wait";
						}
						break;
					}
					case "trade": {
						for (var i = 0; i < this.players.length; i++) {
							this.players[i].tradeOffer = [];
							this.players[i].tradeDemand = [];
							this.players[i].tradeTalk = " ";
						}
						this.send("inTrade\n");
						this.phase = "trade";
						break;
					}
					case "end": {
						this.send("doneTurn\n");
						this.phase = "wait";
						break;
					}
					case "playd_card": {
						var card = this.players[this.id].d_cards[this.candidate[1]];
						if (card == 0) {
							if (!this.players[this.id].playedRobber) {
								this.send("soldier\n");
								this.players[this.id].playedRobber = true;
								this.phase = "wait";
							}
						}
						else {
							this.send("playd_card*" + this.candidate[1] + "*" + card + "\n");
							this.phase = "wait";
						}
						break;
					}
				}	
				this.lastKey = 0;
			}
			break;
		}
		case "login": {
			while (AreKeysLeft()) {
				var key = GetKey();
				switch (key) {
					case KEY_TAB: {
						if (this.loginInfo[3] == "") {
							if (this.loginPage == 2) { this.loginPage = 0; }
							else { this.loginPage++; }
						}
						else {
							if (this.loginPage == 1) { this.loginPage = 0; }
							else { this.loginPage = 1; }
						}
						break;
					}
					case KEY_ENTER: {
						if (this.loginInfo[0] != "" && this.loginInfo[1] != "" && this.loginInfo[2] != "") {
							if (this.loginInfo[3] == "") {
								this.port = OpenAddress(this.loginInfo[2], 1123);
								this.phase = "connecting";
							}
							else {
								this.loginInfo[3] = "";
								this.phase = "connecting";
							}
						}
						break;
					}
					case KEY_BACKSPACE: {
						if (this.loginInfo[this.loginPage] != "") { this.loginInfo[this.loginPage] = this.loginInfo[this.loginPage].substring(0, this.loginInfo[this.loginPage].length - 1); }
						break;
					}
					default: {
						this.loginInfo[this.loginPage] += GetKeyString(key, IsKeyPressed(KEY_SHIFT));
					}
				}
			}
			break;
		}
		case "lobby": {
			if (this.checkKeyDelay() && IsMouseButtonPressed(MOUSE_LEFT)) {
				for (var i = 0; i < this.mapList.length; i++) { if (isMouse(1000, 125+(i*18), 170, 20) && this.id == 0) { this.mapSelected = i; this.send("map*" + this.mapList[this.mapSelected] + "*" + i +  "\n");  } }
				if (isMouse(1020,507,100,20) && this.ready() && this.id == 0) { this.send("start\n"); } 
				var offset = 90;
				for (var i = 0; i < 4; i++) {
					if (isMouse(800+(i*30),10 + offset,20,20) && !this.doPlayerColorsMatch(i)) { 	 this.players[this.id].currentColor = i; this.send("color*"+this.players[this.id].currentColor + "\n"); }
					if (isMouse(800+(i*30),40 + offset,20,20) && !this.doPlayerColorsMatch(i+4)) { this.players[this.id].currentColor = i + 4; this.send("color*"+this.players[this.id].currentColor + "\n"); }
				}
				if (this.id == 0) {
					var info = "";
					if (isMouse(780, 532, 160, 12)) {
						if (this.options.noRobOn2) { this.options.noRobOn2 = false; info = "no"; }
						else { this.options.noRobOn2 = true; info = "yes"; }
						this.send("noRob2*"+ info + "\n");
					}
					if (isMouse(780, 547, 160, 12)) {
						if (this.options.addBoats) { this.options.addBoats = false; info = "no"; }
						else { this.options.addBoats = true; info = "yes"; }
						this.send("optBoats*" + info + "\n");
					}
					if (isMouse(780, 562, 160, 12)) {
						if (this.options.addGoldMine) { this.options.addGoldMine = false; info = "no"; }
						else { this.options.addGoldMine = true; info = "yes"; }
						this.send("addGoldMine*" + info + "\n");
					}
					if (this.candidate > 8 && this.candidate < 16) { 
						this.options.vpToWin = this.candidate; 
						this.send("vpToWin*" + this.options.vpToWin + "\n");
					}
				}
				this.lastKey = 0;
			}
			break;
		}
	}
	if (this.inChat || this.inDebug) {
		while(AreKeysLeft()) {
			var key = GetKey();
			switch(key) {
				case KEY_BACKSPACE: {
					if (this.chat.input != "") { this.chat.input = this.chat.input.substring(0, this.chat.input.length - 1); }
					break;
				}
				case KEY_ENTER: {
					if (this.inChat && this.chat.input != "") {
						this.send("chat*" + this.chat.input + "\n");
						this.chat.input = "";
					}
					if (this.inDebug && this.chat.input != "") {
						this.addChat(3, "", this.chat.input);
						this.chat.input = "";
					}
					break;
				}
				case KEY_ESCAPE:
				case KEY_TILDE:
				case KEY_F1: {
					this.inChat = false;
					this.inDebug = false;
					break;
				}
				default: {
					this.chat.input += GetKeyString(key,IsKeyPressed(KEY_SHIFT));
				}
			}
		}
	}
	else {
		while (AreKeysLeft()) {
			var key = GetKey();
			switch(key) {
				case KEY_TILDE: {
					this.inChat = true;
					break;
				}
				case KEY_F1: {
					this.inDebug = true;
					break;
				}
				case KEY_ESCAPE: {
					if (this.turn == this.id) {
						if (this.phase == "road" || this.phase == "boat" || this.phase == "city" || this.phase == "trade"  || this.phase == "settlement") {
							this.phase = "main";
						}
					}
					break;
				}
			}
		}
	}
	if (this.port != undefined) { this.server(); }
}

_traders.prototype.server = function() {
	if (this.port.getPendingReadSize() > 0) {
		var fullRead = CreateStringFromByteArray(this.port.read(this.port.getPendingReadSize())); //get all pending information
		var seperatedInfo = fullRead.split("\n"); //seperate information in blocks
		while(seperatedInfo.length > 0) { //while there is information to get
			var keyword = seperatedInfo[0].split("*"); //deletes dividers
			switch (keyword[0]) { //what information are we handling
				case "gameOver": {
					this.players[keyword[1]].careerPoints = keyword[2];
					this.players[keyword[1]].wins = keyword[3];
					this.players[keyword[1]].losses = keyword[4];
					break;
				}
				case "optionVP": {
					if (this.id != 0) { this.options.vpToWin = keyword[1]; }
					break;
				}
				case "go": {
					if (this.id == this.turn) { this.phase = "main"; this.helper = "It is your turn."; }
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					break;
				}
				case "updateHelpSettlement": {
					if (this.id == this.turn) { this.helper = "It is your turn to place a road."; }
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to place a road."; }
					break;
				}
				case "optionGoldMine": {
					if (this.id != 0) { 
						if (keyword[1] == "yes") { this.options.addGoldMine = true;  }
						else { this.options.addGoldMine = false; }
					}
					break;
				}
				case "optionBoats": {
					if (this.id != 0) { 
						if (keyword[1] == "yes") { this.options.addBoats = true; }
						else { this.options.addBoats = false; }
					}
					break;
				}
				case "noRobOn2": {
					if (this.id != 0) { 
						if (keyword[1] == "yes") { this.options.noRobOn2 = true; }
						else { this.options.noRobOn2 = false; }
					}
					break;
				}
				case "latency": {
					this.players[keyword[1]].latency = keyword[2];
					break;
				}
				case "ping": {
					this.send("ping\n");
					break;
				}
				case "noPass": {
					this.phase = "login";
					this.loginInfo[3] = "Incorrect password!";
					break;
				}
				case "nameExists": {
					this.phase = "login";
					this.loginInfo[3] = "Name already in game, please choose another.";
					this.loginInfo[0] = "";
					break;
				}
				case "turn2": {
					this.turn = keyword[1];
					break;
				}
				case "chat": {
					this.addChat(keyword[1], keyword[2], keyword[3]);
					break;
				}
				case "rob": {
					if (this.id == this.turn) { 
						if (this.rolled) { this.phase = "main"; this.helper = "It is your turn."; }
						else { this.phase = "roll"; this.helper = "It is your turn to roll the dice"; }
					}
					else
					{
						if (this.rolled) {
							this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; 
						}
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to roll the dice."; }
					}
					this.updates.push(new this.robberUpdate(keyword[1], keyword[2]));
					break;
				}
				case "turn": {
					this.turn = keyword[1];
					if (this.started) {
						if (this.id == keyword[1]) { 
							this.rolled = false; this.phase = "roll"; 
							this.players[this.turn].playedRobber = false;
							this.helper = "It is your turn to roll the dice.";
						}
						else { this.helper =  "Waiting for " + this.players[this.turn].name + " to roll the dice."; }
					}
					else {
						this.starting = true;
						this.drawObject("createBackground"); 
						if (this.id == this.turn) { this.phase = "settlement"; this.helper = "It is your turn to place a settlement."; }
						else { this.phase = "wait"; this.helper = "Waiting for " + this.players[this.turn].name + " to place a settlement.";}
					}
					break;
				}
				case "started": {
					this.started = true;
					this.drawObject("createBackground"); 
					if (this.turn == this.id) { 
						this.phase = "roll"; this.players[this.turn].playedRobber = false; 
						this.helper = "It is your turn to roll the dice.";
					}
					else { 
						this.phase = "wait"; 
						this.helper = "Waiting for " + this.players[this.turn].name + " to roll the dice.";
					}
					break;
				}
				case "robbers": {
					this.robber.where[0] = keyword[1];
					this.robber.where[1] = keyword[2];
					break;
				}
				case "mapList": {
					var maps = keyword[1];
					this.mapList = maps.split(",");
					break;
				}
				case "ports": {
					this.ports = [];
					var pHex = JSON.parse("\[" + keyword[1] + "\]");
					var first =   JSON.parse("\[" + keyword[2] + "\]");
					var second =   JSON.parse("\[" + keyword[3] + "\]");
					var thePort  = JSON.parse("\[" + keyword[4] + "\]");

					for (var i in pHex) { 
						this.ports.push(new _port(pHex[i], first[i], second[i], thePort[i])); 
						this.hex[pHex[i]].port = thePort[i];
					}
					break;
				}
				case "newResource": {
					if (this.started) {
						var r0 = JSON.parse("\[" + keyword[1] + "\]");
						var r1 = JSON.parse("\[" + keyword[2] + "\]");
						var r2 = JSON.parse("\[" + keyword[3] + "\]");
						this.updates.push(new this.resourceUpdate(r0, r1, r2, "gained"));
					}
					break;
				}
				case "number": {
					var number = JSON.parse("\[" + keyword[1] + "\]");
					for (var i = 0; i < HEX_COUNT; i++) {
						this.hex[i].number = number[i];
					}
					break;
				}
				case "board": {
					var image = JSON.parse("\[" + keyword[1] + "\]");
					for (var i = 0; i < HEX_COUNT; i++) {
						this.hex[i].image = image[i];
					}
					break;
				}
				case "map": {
					this.mapSelected = keyword[1];
					break;
				}
				case "color": {
					this.players[keyword[1]].currentColor = keyword[2];
					break;
				}
				case "id": {
					this.id = keyword[1];
					break;
				}
				case "name": {
					this.players[keyword[1]].name = keyword[2];
					break;
				}
				case "connected": {
					if (this.id == keyword[1]) { this.phase = "lobby"; }
					break;
				}
				case "tradeResponse": {
					if (this.turn == this.id) { this.players[keyword[1]].tradeTalk = keyword[2]; }
					break;
				}
				case "choseRobber": {
					if (this.turn == this.id) {
						this.helper = "Move the robber to a new location.";
					}
					else { 
						this.helper = "Waiting for " + this.players[this.turn].name + " to move the Robber.";
					}
					break;
				}
				case "placeRobber": {
					if (this.turn == this.id) { 
						this.phase = "pickRobber"; 
						this.helper = "Pick which Robber you would like to move.";
					}
					else {
						this.helper = "Waiting for " + this.players[this.turn].name + " to pick a Robber to move.";
					}
					break;
				}
				case "discarded": {
					//1 discards 2 discards 3 discards
					if (keyword[1] != "nil") { var r0 = JSON.parse("\[" + keyword[1] + "\]"); }
					else { var r0 = []; }
					if (keyword[2] != "nil") { var r1 = JSON.parse("\[" + keyword[2] + "\]"); }
					else { var r1 = []; }
					if (keyword[3] != "nil") { var r2 = JSON.parse("\[" + keyword[3] + "\]"); }
					else { var r2 = []; }
					this.updates.push(new this.resourceUpdate(r0, r1, r2, "discarded"));
					break;
				}
				case "discard": {
					var over = JSON.parse("\[" + keyword[1] + "\]");
					var text = [];
					for (var i = 0; i < over.length; i++) {
						if (over[i] > 0) { text.push(this.players[i].name); }
					}
					this.discarders = text;
					if (over[this.id] > 0) {
						this.phase = "discard";
						this.toDiscard = [];
						for (var i in this.players[this.id].resources) { this.toDiscard.push("no"); }
						this.players[this.id].discard = over[this.id]; 
						this.helper = "";
					}
					else {
						if (text.length == 2) { this.helper = "Waiting for " + text[0] + " & " + text[1] + " to discard half their hands."; }
						else { this.helper = "Waiting for " + text[0] + " to discard half their hand."; }
					}
					break;
				}
				case "noteDiscard": {
					for (var i = 0; i < this.discarders.length; i++) {
						if (this.discarders[i] == this.players[keyword[1]].name) {
							this.discarders.splice(i, 1);
							break;
						}
					}
					if (this.phase != "discard") {
						if (this.discarders.length == 2) { this.helper = "Waiting for " + this.discarders[0] + " & " + this.discarders[1] + " to discard half their hands."; }
						else { this.helper = "Waiting for " + this.discarders[0] + " to discard half their hand."; }
					}
					break;
				}
				case "afterRoll": {
					this.rolled = true;
					if (this.turn == this.id) { 
						this.phase = "main"; 
						this.helper = "It is your turn.";
					}
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					break;
				}
				case "yop": {
					//1 got 2, 3 from yop
					var a = [];
					a.push(keyword[2], keyword[3]);
					this.updates.push(new this.singleResource(keyword[1], a));
					if (this.id == this.turn) { this.phase = "main"; this.helper = "It is your turn."; }
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					break;
				}
				case "monopoly": { 
					//1 took 2 from 3, 4 from 5, monopolized: 6
					var a = [];
					for (var i = 0; i < keyword[2]; i++) { a.push(keyword[3]); }
					this.updates.push(new this.singleResource(keyword[1], a));
					if (this.id == this.turn) { this.phase = "main"; this.helper = "It is your turn."; }
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					break;
				}
				case "stopRoadBuild": {
					if (this.turn == this.id) { this.phase = "main"; this.helper = "It is your turn."; }
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					break;
				}
				case "pickWhoToRob": {
					if (this.id == this.turn) {
						this.robber.whoToRob = [keyword[2],keyword[3]];
						this.phase = "rob";
						this.helper = "Choose who you would like to Rob.";
					}
					else { this.helper = "Waiting for " + this.players[this.turn].name + " to choose who to Rob."; }
					break;
				}
				case "playd_card": {
					this.players[keyword[1]].tableCards.push(keyword[2]);
					if (keyword[2] == 0) {
						if (keyword[1] == this.id) { this.phase = "pickRobber"; this.helper = "Choose a Robber to move."; }
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to choose which Robber to move"; }
					}
					else if (keyword[2] == 1) { 
						if (keyword[1] == this.id) { this.phase = "roadBuilder"; this.roadsBuilt = 0; this.helper = "You may build 2 free roads."; }
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to built their free roads."; }
					}
					else if (keyword[2] == 2) { 
						if (keyword[1] == this.id) { this.phase = "monopoly"; this.helper = "Choose a resource to monopolize."; }
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to pick a resource to monopolize."; }
					}
					else if (keyword[2] == 3) { 
						if (keyword[1] == this.id) { this.phase = "yop"; this.yop = []; this.helper = "Pick 2 cards to collect for Year of Plenty."; }
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to pick 2 cards from Year of Plenty."; }
					}
					else { 
						if (keyword[1] == this.id) { this.phase = "main"; this.helper = "It is your turn."; } //vp.
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					}
					if (keyword[1] != this.id) {
						this.updates.push(new this.largeImageUpdate(this.developmentCards[keyword[2]], this.players[keyword[1]].name + " has placed a development card.", keyword[1]));
					}
					break;
				}
				case "noRob": {
					if (this.id == this.turn) { 
						if (this.rolled) { this.phase = "main"; this.helper = "It is your turn."; }
						else { this.phase = "roll"; this.helper = "It is your turn to roll the dice."; }
					}
					else {
						if (this.rolled) { this.helper = "Waiting for " + this.players[this.turn].name + " to roll the dice."; }
						else { this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					}
					break;
				}
				case "robber": {
					this.hex[this.robber.where[keyword[2]]].robber = false;
					this.robber.where[keyword[2]] = keyword[3];
					this.hex[keyword[3]].robber = true;
					this.updates.push(new this.update(this.hex[keyword[3]].x + 44, this.hex[keyword[3]].y + 40, this.players[keyword[1]].name + " has moved the robber here."));
					break;
				}
				case "largestArmy": {
					this.largestArmy = keyword[1];
					this.updates.push(new this.wordUpdate(keyword[1], this.players[keyword[1]].name + " now has the", "largest army!"));
					break;
				}
				case "city": {
					//1-who, 2-which settlement
					this.players[keyword[1]].cities.push(this.players[keyword[1]].settlements[keyword[2]]);
					this.players[keyword[1]].settlements.splice(keyword[2], 1);
					var x = this.corners[this.players[keyword[1]].cities[this.players[keyword[1]].cities.length - 1]].x;
					var y = this.corners[this.players[keyword[1]].cities[this.players[keyword[1]].cities.length - 1]].y;
					if (keyword[1] != this.id) { this.updates.push(new this.update(x, y, this.players[keyword[1]].name + " upgraded to a city!")); }
					else { this.phase = "main"; }
					break;
				}
				case "inTrade": {
					if (this.turn != this.id) {
						this.helper = this.players[this.turn].name + " is in the trade window.";
					}
					break;
				}
				case "trade": {
					var r0 = JSON.parse("\[" + keyword[2] + "\]");
					var r1 = JSON.parse("\[" + keyword[4] + "\]");
					this.updates.push(new this.doubleSingleResource(keyword[1], r1, keyword[3], r0));
					if (keyword[1] == this.id) {
						this.phase = "main";
						this.helper = "It is your turn.";
					}
					else {
						this.receivedTrade = -1;
						this.phase = "wait";
						this.helper = "Waiting for " + this.players[this.turn].name + " to finish their turn.";
					}
					break;
				}
				case "leftTrade": {
					if (this.turn != this.id && keyword[1] == this.id) { this.receivedTrade = -1; this.phase = "wait"; }
					if (keyword[1] == this.turn && keyword[1] != this.id) { this.helper =  "Waiting for " + this.players[this.turn].name + " to finish their turn."; }
					else if(keyword[1] == this.turn && this.turn == this.id) { this.helper = "It is your turn."; }
					break;
				}
				case "propose": {
					this.players[keyword[1]].tradeDemand = JSON.parse("\[" + keyword[2] + "\]");
					this.players[keyword[1]].tradeOffer =  JSON.parse("\[" + keyword[3] + "\]");
					if (this.turn != this.id && this.phase != "receivedTrade" && this.turn == keyword[1]) {
						this.receivedTrade = keyword[1];
						this.phase = "receivedTrade";
						for (var i = 0; i < this.players.length; i++) {
							if (i != keyword[1]) {
								this.players[i].tradeOffer = [];
								this.players[i].tradeDemand = [];
							}
						}
					}
					else if (this.turn == this.id && keyword[1] == this.id) {
						for (var i = 0; i < this.players.length; i++) {
							if (i != this.turn) {
								this.players[i].tradeOffer = [];
								this.players[i].tradeDemand = [];
								this.players[i].tradeTalk = "";
							}
						}
					}
					break;
				}
				case "roll": {
					this.dice[0] = keyword[1];
					this.dice[1] = keyword[2];
					this.lastRoll = keyword[3];
					this.allRolls[this.lastRoll]++;
					this.totalRolls++;
					this.rolled = true;
					this.updates.push(new this.update(710, 630, this.players[this.turn].name + " has rolled a " + this.lastRoll + "."));
					break;
				}
				case "winner": { 
					this.phase = "winner";
					break;
				}
				case "boughtDcard": {
					if (this.id == keyword[1]) {  
						this.updates.push(new this.largeImageUpdate(this.developmentCards[keyword[2]], "", this.id));
						this.phase = "main";
					}
					else { this.updates.push(new this.builtUpdate(keyword[1], [1,2,3], [5])); }
					break;
				}
				case "dCards": {
					var dCards = JSON.parse("\[" + keyword[2] + "\]");
					this.players[keyword[1]].d_cards = dCards;
					break;
				}
				case "longestRoad": {
					this.longestRoad = keyword[1];
					this.updates.push(new this.wordUpdate(keyword[1], this.players[keyword[1]].name + " now has the", "longest road!"));
					break;
				}
				case "havePorts": {
					if (keyword[1] == this.id) {
						var ports = JSON.parse("\[" + keyword[2] + "\]");
						this.havePorts = ports;
					}
					break;
				}
				case "boat": {
					this.players[keyword[1]].roads.push(keyword[2]);
					this.players[keyword[1]].boats++;
					this.roads[keyword[2]][3] = true;
					this.roads[keyword[2]][2] = keyword[1];
					var a = (this.corners[this.roads[keyword[2]][1]].x - this.corners[this.roads[keyword[2]][0]].x) / 2;
					var x = this.corners[this.roads[keyword[2]][0]].x + a;
					var y = this.corners[this.roads[keyword[2]][0]].y;
					if (keyword[1] != this.id) { this.updates.push(new this.update(x, y, this.players[keyword[1]].name + " has built a boat.")); }
					else { this.phase = "main"; }
					break;
				}	
				case "road": {
					this.players[keyword[1]].roads.push(keyword[2]);
					this.roads[keyword[2]][2] = keyword[1];
					var a = (this.corners[this.roads[keyword[2]][1]].x - this.corners[this.roads[keyword[2]][0]].x) / 2;
					var x = this.corners[this.roads[keyword[2]][0]].x + a;
					var y = this.corners[this.roads[keyword[2]][0]].y;
					if (keyword[1] != this.id) { this.updates.push(new this.update(x, y, this.players[keyword[1]].name + " has built a road.")); }
					else {
						if (!this.started) { this.phase = "wait"; }
						else {
							if (this.roadsBuilt == 1) { this.phase = "roadBuilder"; }
							else { this.phase = "main"; }	
						}
					}
					break;
				}
				case "resources": {
					var resource = JSON.parse("\[" + keyword[2] + "\]");
					this.players[keyword[1]].resources = resource;
					break;
				}
				case "settlement": {
					this.players[keyword[1]].settlements.push(keyword[2]);
					this.occupyNeighbour(keyword[2]);
					this.corners[keyword[2]].occupied = keyword[1];
					if (keyword[1] != this.id) { this.updates.push(new this.update(this.corners[keyword[2]].x, this.corners[keyword[2]].y, this.players[keyword[1]].name + " has placed a settlement.")); }
					else {
						if (!this.started && this.id == keyword[1]) { this.phase = "road"; }
					}
					break;
				}
				case "points": {
					this.players[keyword[1]].points = keyword[2];
					break;
				}
				case "placeRoad": {
					if (this.turn == this.id) { 
						if (!this.started) { this.phase = "road"; }
						else { this.phase = "main"; }
					}
					break;
				}
				default: {
					if (keyword[0] != "") { Abort(keyword[0]); }
				}
			}
			seperatedInfo = seperatedInfo.slice(1, seperatedInfo.length);
		}
	}
}

_traders.prototype.drawObject = function(WHAT) {
	switch(WHAT) {
		case "port": {
			for (var i in this.ports) {
				Line(this.corners[this.ports[i].a].x-1, this.corners[this.ports[i].a].y, this.hex[this.ports[i].id].x + 34, this.hex[this.ports[i].id].y + 40, this.color[1]);
				Line(this.corners[this.ports[i].b].x-1, this.corners[this.ports[i].b].y, this.hex[this.ports[i].id].x + 34, this.hex[this.ports[i].id].y + 40, this.color[1]);
				this.portImage[this.hex[this.ports[i].id].port].blit(this.hex[this.ports[i].id].x + 26, this.hex[this.ports[i].id].y + 30);
			}
			break;
		}
		case "thisPlayer": {
			if (this.phase != "discard") {
				var pos = this.players[this.id].resources.length * 10;
				for (var i = 0; i < this.players[this.id].resources.length; i++) {
					var a = 0;
					this.resources[this.players[this.id].resources[i]].blit(499 - pos + (i * 20), 650 - a);
				}
			}
			for (var i = 0; i < this.players[this.id].d_cards.length; i++) {
				this.developmentCards[this.players[this.id].d_cards[i]].blit(900 + (i * 20), 680);
			}
			for (var i = 0; i < this.players[this.id].tableCards.length; i++) {
				this.developmentCards[this.players[this.id].tableCards[i]].blit(900 + (i * 20), 560);
			}
			break;
		}
		case "dice": {
			this.window[0].drawWindow(690, 580, 60, 40);
			if (this.phase == "roll") {
				this.dice[0] = getRandom(0,5);
				this.dice[1] = getRandom(0,5);
				Rectangle(0, 0, 755, 575, this.color[7]);
			}
			this.die[this.dice[0]].blit(697, 590);
			this.dieRed[this.dice[1]].blit(722, 590);
			var b = 0;
			for (var i = 2; i < this.allRolls.length; i++) {
				var a = (this.allRolls[i] / this.totalRolls) * 80;
				if (a < 5) { a = 2; }
				Rectangle(750 + (i * 5), 620 - a, 3, a, this.color[9]);
			}
			break;
		}
		case "players": { 
			var space = 120;
			var x = 780;
			var y = 100;
			for (var i = 0; i < this.players.length; i++) { 
				var pColor = this.color[this.pieceColors[this.players[i].currentColor]];
				if (pColor == this.color[0]) { pColor = this.color[5]; }
				if (this.turn == i) {
					Rectangle(x, y+(space*i), 400, 90, pColor);
					Rectangle(x+2, y+(space*i), 400, 88, this.color[0]);
				}
				if (this.phase == "rob" && this.candidate != -1 && this.turn == this.id && isMouse(780, 100 + (i * 120), 400, 120) && i != this.id) { Rectangle(x+2, y+(space*i), 400, 88, CreateColor(0,0,0)); Rectangle(x+2, y+(space*i), 400, 88, CreateColor(255,255,0,20)); }
				if (pColor != this.color[0]) { Rectangle(x, y + (i * space), 15, 15, pColor); this.font.setColorMask(pColor); }
				else  { this.font.setColorMask(this.color[1]); Rectangle(x, y + (i * space), 15, 15, this.color[5]); Rectangle(x+1, y+1 + (i * space), 17, 17, this.color[0]); }
				this.font.drawText(x+22, y + (i * space), this.players[i].name);
				this.font.setColorMask(this.color[4])
				this.font.drawText(x + 200, y + (i * space), "(" + this.players[i].points + ")");
				for (var j = 0; j < this.players[i].resources.length; j++) { this.image["resource"].blit(x + 5 +(j*10),y+20+(space*i)); }
				for (var j = 0; j < this.players[i].d_cards.length; j++) { this.image["d_card"].blit(x + 5 +(j*10),y+45+(space*i)); }
				var vp = 0; var soldier = 0;
				for (var j = 0; j < this.players[i].tableCards.length; j++) {
					if (this.players[i].tableCards[j] == 0) { this.image["sSoldier"].blit(x+270+(soldier*13), y+(space*i)); soldier++; }
					if (this.players[i].tableCards[j] > 3) { this.image["vp"].blit(x+270+(vp*13), y+44+(space*i)); vp++; }
				}
				for (var j = 0; j < 5; j++) {
					if (this.players[i].latency < (500 - (j * 100))) { var latColor = this.color[1]; }
					else { var latColor = this.color[14]; }
					Line(x + 388 + (j*3), y + 83 + (space*i), x + 388 + (j*3), y + 82 - (j*2) + (space*i), latColor);
					Line(x + 389 + (j*3), y + 83 + (space*i), x + 389 + (j*3), y + 82 - (j*2) + (space*i), latColor);
				}
				//draw largest army emblem
				if (this.largestArmy == i) {
					Rectangle(x + 265, y + (space*i) + 12, this.font.getStringWidth(" LARGEST ARMY "), 18, this.color[2]);
					this.font.setColorMask(this.color[0]);
					this.font.drawText(x + 265, y + (space*i) + 13, " LARGEST ARMY");
				}
				//draw longest road emblem
				if (this.longestRoad == i) { this.image["longestRoad"].blit(x + 235, y + (space*i) + 15); }
			}
			break;
		}
		case "createBackground": {
			this.mouse = "";
			Triangle(0, 0, 750, 0, 0, 150, this.color[this.pieceColors[this.players[this.id].currentColor]]);
			this.drawObject("hex");
			this.drawObject("hexNumbers");
			this.drawObject("port");
			this.background = GrabImage(0,0,757,565); 
			this.mouse = LoadImage("mouse.png");
			break;
		}
		case "pieces": {
			for (var i = 0; i < this.players.length; i++) {
				for (var j = 0; j < this.players[i].roads.length; j++) {
					var x1 = this.corners[this.roads[this.players[i].roads[j]][0]].x;
					var y1 = this.corners[this.roads[this.players[i].roads[j]][0]].y;
					var x2 = this.corners[this.roads[this.players[i].roads[j]][1]].x;
					var y2 = this.corners[this.roads[this.players[i].roads[j]][1]].y;
					//road, boat, settlement, city.
					if (y1 > y2 && x1 != x2) { //diagonal up
						if (!this.roads[this.players[i].roads[j]][3]) { this.pieces[this.players[i].currentColor][0].rotateBlit(x1 + 15,y1 - 20,DegreesToRadians(60)); }
						else { this.pieces[this.players[i].currentColor][1].rotateBlit(x1 + 15,y1 - 20,DegreesToRadians(60)); }
					}
					else if (y1 < y2 && x1 != x2) { //diagonal down
						if (!this.roads[this.players[i].roads[j]][3]) { this.pieces[this.players[i].currentColor][0].rotateBlit(x1 + 15, y1 + 1,DegreesToRadians(300)); }
						else { this.pieces[this.players[i].currentColor][1].rotateBlit(x1 + 15, y1 + 1,DegreesToRadians(300)); }
					} 
					else {
						if (!this.roads[this.players[i].roads[j]][3]) { this.pieces[this.players[i].currentColor][0].blit(x1 - 3, y1 + 9); }
						else { this.pieces[this.players[i].currentColor][1].blit(x1 - 3, y1 + 9); }
					}
				}
				for (var j = 0; j < this.players[i].settlements.length; j++) {
					var settle = this.players[i].settlements[j];
					this.pieces[this.players[i].currentColor][2].blit(this.corners[settle].x - 9, this.corners[settle].y - 6);
				}
				for (var j = 0; j < this.players[i].cities.length; j++) {
					var city = this.players[i].cities[j];
					this.pieces[this.players[i].currentColor][3].blit(this.corners[city].x -14, this.corners[city].y - 6);
				}
			}
			break;
		}
		case "buttons": {
			for (var i = 0; i < this.buttonsOff.length; i++) {
				this.buttonsOff[i].blit(20 + (i*50), 580);
			}
			break;
		}
		case "background": {
			this.background.blit(0,0);
			break;
		}
		case "robbers": {
			this.robber.image.blit(this.hex[this.robber.where[0]].x + 23, this.hex[this.robber.where[0]].y + 29);
			this.robber.image.blit(this.hex[this.robber.where[1]].x + 23, this.hex[this.robber.where[1]].y + 29);
			break;
		}
		case "hexNumbers": {
			for (var i = 0; i < this.hex.length; i++) {
				if (this.hex[i].number > 9) { offset = -3; }
				else { offset = 0; }
				if (this.hex[i].number == 6 || this.hex[i].number == 8) { this.font.setColorMask(this.color[2]); }
				else { this.font.setColorMask(this.color[0]); }
				if (this.hex[i].image < 5) {
					FilledCircle(this.hex[i].x + 34, this.hex[i].y + 40, 11, this.color[12], true);
					this.font.drawText(this.hex[i].x + offset + 30, this.hex[i].y + 32, this.hex[i].number);
				}
			}
			break;
		}
		case "hex": {
			for (var i = 0; i < this.hex.length; i++) { this.hexImage[this.hex[i].image].blit(this.hex[i].x, this.hex[i].y); }
			break;
		}
	}
}

_traders.prototype.ableToRob = function(HEX) {
	var robable = true;
	if (this.options.noRobOn2) {
		var possible = this.findCornersOnHex(HEX);
		if (possible.length > 0 ) {
			for (var i = 0; i < possible.length; i++) {	
				if (this.corners[possible[i]].occupied != - 1 && this.corners[possible[i]].occupied != 9 && this.players[this.corners[possible[i]].occupied].points < 3) {
					robable = false;
				}
			}
		}
	}
	return robable;
}

_traders.prototype.status = function() {
	this.font.setColorMask(this.color[1]);
	var start = this.font.getStringWidth(this.helper) / 2;
	this.font.drawText(505 - start, 580, this.helper);
}

function _player() {
	this.name = "";
	this.careerPoints = 0;
	this.wins = 0;
	this.losses = 0;
	this.currentColor;
	this.roads = [];
	this.boats = [];
	this.settlements = [];
	this.cities = [];
	this.boats = 0;
	this.points = 0;
	this.resources = [];
	this.d_cards = [];
	this.tableCards = [];
	this.tradeOffer = [];
	this.tradeDemand = [];
	this.tradeTalk = "";
	this.playedRobber = false;
	this.discard = 0;
	this.latency = 0;
}
